//  Listing 10.5. Klasa Rational i jej funkcja testujca "test driver"

#include <iostream>
using namespace std;

class Rational 
{
long nmr, dnm; 				// prywatne dane
void normalize(); 			// prywatne metody
public:
Rational() 				// konstruktor domylny - zero
{ nmr = 0; dnm = 1; }
Rational(long n, long d) 		// konstruktor oglny - uamek n/d
{ nmr = n; dnm = d;
this->normalize(); }
	// sowo const - docelowe obiekty nie bd modyfikowane
Rational operator + (const Rational &x) const; 
Rational operator - (const Rational &x) const;
Rational operator * (const Rational &x) const;
Rational operator / (const Rational &x) const;
	// brak sowa const - docelowe obiekty bd modyfikowane
void operator += (const Rational &x); 
void operator -= (const Rational&);
void operator *= (const Rational&);
void operator /= (const Rational&);
	// sowo const - docelowe obiekty nie bd modyfikowane
bool operator == (const Rational &other) const;
bool operator < (const Rational &other) const;
bool operator > (const Rational &other) const;
void show() const;
} ; 					// koniec specyfikacji klasy

Rational Rational::operator + (const Rational &x) const
 { return Rational(nmr*x.dnm + x.nmr*dnm, dnm*x.dnm); }
Rational Rational::operator - (const Rational &x) const
 { return Rational(nmr*x.dnm - x.nmr*dnm, dnm*x.dnm); }
Rational Rational::operator * (const Rational &x) const
 { return Rational(nmr * x.nmr, dnm * x.dnm); }
Rational Rational::operator / (const Rational &x) const
 { return Rational(nmr * x.dnm, dnm * x.nmr); }

void Rational::operator += (const Rational &x)
{ 
  nmr = nmr * x.dnm + x.nmr * dnm; 	// 3/8+3/2=(6+24)/16=15/8
  dnm = dnm * x.dnm; 			// n1/d1+n2/d2 = (n1*d2+n2*d1)/(d1*d2)
  this->normalize(); 
}

void Rational::operator -= (const Rational &x)
{ 
  nmr = nmr * x.dnm - x.nmr * dnm; 	// 3/8+3/2=(6+24)/16=15/8
  dnm = dnm * x.dnm; 			// n1/d1+n2/d2 = (n1*d2-n2*d1)/(d1*d2)
  this->normalize(); 
}

void Rational::operator *= (const Rational &x)
{ 
  nmr = nmr * x.nmr; 
  dnm = dnm * x.dnm;
  this->normalize(); 
}

void Rational::operator /= (const Rational &x)
{ 
  nmr = nmr * x.dnm; 
  dnm = dnm * x.nmr;
  this->normalize(); 
}

bool Rational::operator == (const Rational &other) const
{ 
  return (nmr * other.dnm == dnm * other.nmr); 
}

bool Rational::operator < (const Rational &other) const
{ 
  return (nmr * other.dnm < dnm * other.nmr); 
}

bool Rational::operator > (const Rational &other) const
{ 
  return (nmr * other.dnm > dnm * other.nmr); 
}

void Rational::normalize() 		// prywatna metoda 
{ 
if (nmr == 0) { dnm = 1; return; 
}

int sign = 1;
if (nmr < 0) { sign = -1; nmr = -nmr; } 	// tylko dla zilustrowania
if (dnm < 0) { sign = -sign; dnm = -dnm; }
long gcd = nmr, value = dnm; 			// znajd n.w.p.
while (value != gcd) 				// zatrzymaj po znalezieniu n.w.p.
{ 
  if (gcd > value)
  gcd = gcd - value; 				// odejmij mniejsz liczb od wikszej
  else value = value - gcd; 
}
nmr = sign * (nmr/gcd); dnm = dnm/gcd; 		// mianownik dodatni
}

void Rational::show() const
{ 
  cout << " " << nmr << "/" << dnm; 
}

int main()
{ 
  Rational a(1,4), b(3,2), c, d;
  c = a + b; 					// c.nmr wynosi 7, c.dnm wynosi 4
  a.show(); cout << " +"; b.show(); cout << " =";
  c.show(); cout << endl;
  d = b - a;
  b.show(); cout << " -"; a.show(); cout << " =";
  d.show(); cout << endl;
  c = a * b; 					// c.nmr wynosi 3, c.dnm wynosi 8
  a.show(); cout << " *"; b.show(); cout << " =";
  c.show(); cout << endl;
  d = b / a;
  b.show(); cout << " /"; a.show(); cout << " =";
  d.show(); cout << endl;
  c.show();
  c += b;
  cout << " +="; b.show(); cout << " ="; c.show(); cout << endl;
  d.show();
  d *= b;
  cout << " *="; b.show(); cout << " ="; d.show(); cout << endl;
  if (b < c)
    { b.show(); cout << " <"; c.show(); cout << endl; }
  return 0;
}
